<?php defined('SYSPATH') or die('No direct script access.');

class Users extends Migration{

    public $schema = 'public';
    public $table = 'users';

    public function up(){
        $this->run_query(DB::expr(
            "CREATE TABLE users(
                id serial PRIMARY KEY,
                username varchar(32) NOT NULL UNIQUE,
                password varchar(64) NOT NULL,
                logins integer NOT NULL DEFAULT 0,
                last_login integer,
                CONSTRAINT users_logins_check CHECK (logins >= 0)
            );"
        ));
    }

    public function down(){
        $this->set_schema($this->schema);
        $this->drop_table($this->table);
    }
}